<?php

namespace Modules\Api\Http\Requests;

use App\Http\Requests\Request;

/**
 * Contact API Request
 *
 * Class ContactApiRequest
 *
 * @package Modules\Api\Http\Requests
 */
class ContactApiRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email',
            'secondary_email' => 'sometimes|nullable|email',
        ];
    }
}
