<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 class Operator extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->load->library('session');
		$this->load->helper("security");
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		if(!$this->session->userdata('adminLoggedIn') || $this->session->userdata('adminLoggedIn')=='')
		{
			redirect('login');
		}
    }
 
	//Check admin session
	
	
	public function index()
	{
		$data['page_title']='Operator List';
		$admin_id = $this->session->userdata['adminLoggedIn']['adminId'];
		$data['result'] = $this->Mainmodel->select_results_where_orderBy('admin',array('status !='=>'deleted','admin_type'=>'sub','added_by'=>$admin_id),'admin_id');
		$data['main_content'] = 'operator_list';
		$this->load->view('includes/template',$data);
	}
	public function add()
	{
		$data['page_title'] = "Lead Management | Add Operator";
		$admin_id = $this->session->userdata['adminLoggedIn']['adminId'];

		if(isset($_POST['submit']))
		{
			$this->load->library('email');				
			$this->form_validation->set_rules('admin_name', 'Name', 'trim|required');	
			$this->form_validation->set_rules('username', 'Username', 'trim|required|is_unique[admin.username]');	
			$this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[12]');	
			$this->form_validation->set_message('min_length', 'The value you have entered for %s is too short');
			$this->form_validation->set_message('max_length', 'The value you have entered for %s is too long');
			$this->form_validation->set_rules('admin_contact_number', 'Mobile', 'trim|regex_match[/^[0-9]{10}$/]|required|is_unique[admin.admin_contact_number]');
			$this->form_validation->set_message('regex_match', 'Invalid %s Number');
			$this->form_validation->set_rules('admin_email_id', 'Email', 'trim|is_unique[admin.admin_email_id]|required');
			
			if($this->form_validation->run() == true){
				$params=array(
					'admin_name'=>$this->input->post('admin_name'),
					'username'=>$this->input->post('username'),					
					'password'=>base64_encode($this->input->post('password')),
					'admin_type'=>'sub',
					'admin_contact_number'=>$this->input->post('admin_contact_number'),
					'admin_email_id'=>$this->input->post('admin_email_id'),
					'added_by'=>$admin_id,
					'admin_reg_date'=>date('Y-m-d H:i:s'),
				);

				$insert = $this->db->insert('admin',$params);
				if($insert)
				{
					$this->session->set_flashdata('success','Operator Added Successfully');
					redirect('operator/add');
				}
			}
		}
		$data['main_content'] = "add-operator";
		$this->load->view('includes/template',$data);
	}
	
	public function details()
	{
		$data['page_title']='Operator Details';
		$id=$this->uri->segment(3);
		if($id!="")
		{
			$data['result'] = $this->Mainmodel->select_single_row('admin',array('status !='=>'deleted','admin_id'=>$id));
			$data['clients']=$this->Mainmodel->getclients($id);
			$data['appointments']=$this->Mainmodel->getAppointmentList($id);
		}
		$data['main_content'] = 'operator-details';
		$this->load->view('includes/template',$data);
	}
	public function change_status()
	{
		$id=$this->uri->segment(3);
		$adminData = $this->Mainmodel->select_single_row('admin',array('admin_id'=>$id));
		if($adminData->status=='active')
		{
			$this->db->where('admin_id',$id);
			$this->db->update('admin',array('status'=>'deactive'));
			$this->session->set_flashdata('success','Status Changed Successfully');
			redirect('operator');
		}
		else if($adminData->status=='deactive')
		{
			$this->db->where('admin_id',$id);
			$this->db->update('admin',array('status'=>'active'));
			$this->session->set_flashdata('success','Status Changed Successfully');
			redirect('operator');
		}
	}
	public function delete_operator()
	{
		$id=$this->uri->segment(3);
		$adminData = $this->Mainmodel->select_single_row('admin',array('admin_id'=>$id));
		if($adminData)
		{
			$this->db->where('admin_id',$id);
			$this->db->update('admin',array('status'=>'deleted'));
			$this->session->set_flashdata('success','Operator Deleted Successfully');
			redirect('operator');
		}
		else {
			$this->session->set_flashdata('success','Something Went Wrong, Please Try Again');
			redirect('operator');
		}
	}
	
	
	public function publish()
	{
		$id=$this->uri->segment(3);
		$page_name=$this->uri->segment(4);
		$table=$this->uri->segment(5);
		$field_name=$this->uri->segment(6);
		$status=$this->uri->segment(7);
		$status_field=$this->uri->segment(8);
		$publish=$this->Mainmodel->comm_publish($id,$table,$field_name,$status,$status_field);
		if($publish)
		{
			$this->session->set_flashdata('success',$status.' Successfully');
			redirect($page_name);
		}
	}
 }
 ?>