<?php
class Mainmodel extends CI_Model{
		
    function __construct() 
    {
        parent::__construct();
		$this->load->database();
    }
	function select_results_where( $table , $whereclaus)
    {
        $query = $this->db->get_where( $table, $whereclaus );
        $result = $query->result();
        
        $query->free_result();
        return $result;
    }

    function select_results_where_orderBy( $table , $whereclaus,$order_by)
    {
		$this->db->select('*');
        $this->db->from($table);
        $this->db->where($whereclaus); 
        $this->db->order_by($order_by); 
        $query=$this->db->get();
		$result = $query->result();
        
        $query->free_result();
        return $result;
    }

    function insertData( $table ) 
    {
        $fields = $this->db->list_fields($table);
        $data = array();
        foreach ( $fields as $field ) {
            if (isset($_POST[$field]))
			{
                $data[$field]= $this->input->post($field);
                if (is_array($_POST[$field])) 
				{
				 $data[$field] = implode( ',',array_map('strtolower',$this->input->post($field)) );
				}
				else
				{
					$data[$field]= $this->input->post($field);
				}
            }
        }
        $result=$this->db->insert($table, $data);
		return $result;
    }

    function delete($id,$tablename)
    {
        $this->db->where($id);
        $result = $this->db->delete($tablename);
        return $result;
    }

    function select_single_row($table, $where)
    {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where($where);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }
    function select_data_by_initial($where)
    {
        $this->db->select('disease_title,disease_slug');
        $this->db->from('disease');
        $this->db->like('disease_title',$where,'after');
        $this->db->where('status','Active');
        $query = $this->db->get();
        if($query->num_rows()>0)
        {
            $result = $query->result();
            return $result;
        }
        else
        {
            return false;
        }
        
    }
    function update($data,$conditions,$tablename="")
    {
        if($tablename=="")
        $tablename = $this->table;
        $this->db->where($conditions);
        $this->db->update($tablename,$data);
        return $this->db->affected_rows();
    }
	
    function get_disease_sort_order($table,$where)
    {
        $this->db->select('sort_order');
        $this->db->where($where);
        $this->db->order_by('sort_order desc');
        $this->db->limit('1');
        $this->db->from($table);
        $result = $this->db->get();
        $sort_order=$result->row_array();
        return $sort_order['sort_order']+1;
    }

	function GetSortOrder($table,$column)
	{
		$this->db->select_max($column);
		$result = $this->db->get($table)->row();  
		$sort_order = $result->$column+1;
		return $sort_order;
	}

    function select_results_where1( $table , $whereclaus ,$order_by="" )
    {
        $this->db->select('*');
        $this->db->from($table);
        if($whereclaus!="")
        $this->db->where($whereclaus);
        if($order_by!="")
        $this->db->order_by($order_by);
        $query=$this->db->get(); 
        $result=$query->result();
        $query->free_result();
        return $result;
    }

    function select_row_allpara($id, $table, $where, $order_by, $limit,$start)
    {
        $this->db->select($id);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->order_by($order_by);
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
   }
    function count_all($id, $table, $where='')
    {   
        $this->db->select($id);
        $this->db->from($table);
        if($where)
        {$this->db->where($where);}
        $query = $this->db->get();
        return $query->num_rows();
   }
    public function fetch_case($limit, $start,$table, $where='')
    {
       $this->db->limit($limit, $start);
       $this->db->where($where);
       $query = $this->db->get("case_study");
       if ($query->num_rows() > 0) 
       {
           foreach ($query->result() as $row) 
           {
                $data[] = $row;
           }
           return $data;
       }
       return false;
   }
    public function fetch_testimonial($limit, $start,$table, $where='')
    {
       $this->db->limit($limit, $start);
       $this->db->where($where);
       $query = $this->db->get("testimonial");
       if ($query->num_rows() > 0) 
       {
           foreach ($query->result() as $row) 
           {
                $data[] = $row;
           }
           return $data;
       }
       return false;
   }

  
	public function login($username,$password) 
	{
		$this->db->select('*');
		$this->db->from('admin');
		$this->db->where('username',$username); 
		$this->db->where('password',base64_encode($password)); 
		$this->db->where('status','active'); 
		$this->db->limit(1);
		$query = $this->db->get();
		if ($query->num_rows() == 1) 
		{
			return $query->row();
		} 
		else 
		{
			return false;
		}
	}
		function comm_publish($id,$table,$field_name,$status,$status_field)
	{
		 $this->db->where("$field_name", $id);
		$this->db->update("$table", array("$status_field" => $status));
		return true;
	}
	public function getAppointmentList($id)
	{
		$result=$this->db->select('t1.*,t2.*')
			 ->from('lm_appointment as t1')
			->where('t1.added_by',$id)
			 ->join('lm_client as t2', 't1.client_id = t2.client_id', 'INNER')			
			 ->get()->result();
			 return $result;
	}
	public function getclients($id="")
	{
		$where="";
		if($id!='')
		{
			$where = " AND t1.added_by = $id";
		}
		$result = $this->db->select('t1.*,t2.*')
			 ->from('lm_client as t1')
			->where('client_status ="Active"'.$where)		 
			 ->join('lm_group as t2', 't1.group_id = t2.group_id', 'INNER')			
			 ->get()->result();
		return $result;
	}
	
	
	
	
} //class close