<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 class Client extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->load->helper('all_function_helper');
		$this->load->library('session');
		$this->load->helper("security");
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		if(!$this->session->userdata('admin_LoggedIn') || $this->session->userdata('admin_LoggedIn')=='')
		{
			redirect('login');
		}
    }
 
	//Check admin session
	
	
	public function index()
	{
		$data['page_title'] = "Lead Management | Add Client";
		$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
		$data['adminData']=$this->Mainmodel->select_single_row('admin',array('admin_id'=>$admin_id,'status'=>'active'));
		
		$data['group']=$this->db->get_where('group',array('group_status'=>'Publish'))->result();
			if($_POST)
			{
				$this->load->library('email');				
				$this->form_validation->set_rules('name', 'Name', 'trim|required');	
				$this->form_validation->set_rules('group', 'Group', 'trim|required');	
				$this->form_validation->set_rules('mobile', 'Mobile', 'trim|regex_match[/^[0-9]{10}$/]');
				$this->form_validation->set_rules('phone', 'Phone', 'trim|regex_match[/^[0-9]/]');
				//$this->form_validation->set_rules('email', 'Email', 'trim|is_unique[client.client_email]|required');
				$quatation_file="";
				$this->form_validation->set_rules('address', 'Address', 'trim|required');		
			 if($this->form_validation->run() == true){

			 	 if($_FILES["quotation_file"]['name'] !="") 
			 	 {
							$quatation_file = $this->Mainmodel->doc_upload(6,'quotation_file','quatation_files');
							//echo $quatation_file;die;
				 }
				$date=date('Y-m-d H:i:s');
				
				$params=array(	
					'group_id'=>$this->input->post('group'),
					'client_name'=>$this->input->post('name'),					
					'client_address'=>$this->input->post('address'),
					'client_mobile'=>$this->input->post('mobile'),
					'client_phone'=>$this->input->post('phone'),
					'client_email'=>$this->input->post('email'),
					'quatation'=>$quatation_file,
					'remark'=>$this->input->post('remark'),
					'added_by'=>$admin_id,
					'added_date'=>$date						
					);
				
					$insert=$this->db->insert('client',$params);
					if($insert)
					{
						$this->session->set_flashdata('success','Client registered!');
						redirect(base_url().'client-list.php');
					}
			 }					
			}
		$data['main_content'] = "add-client";
		$this->load->view('includes/template',$data);
	}
	public function client_list()
	{
		$data['page_title']='Client List';
		$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
		$admin_type = $this->session->userdata['admin_LoggedIn']['admin_type'];
		//$data['result']=$this->db->get_where('client',array('client_status'=>'Active'))->result();
		$data['operators']= $this->Mainmodel->select_results_where('admin',array('admin_type'=>'sub','status'=>'active'));
		if(isset($_POST['search']))
		{
			$from_date = $this->input->post('from_date');
			$to_date = $this->input->post('to_date');
			$from_date = str_replace('/', '-', $from_date);
	        $from_date=date('Y-m-d', strtotime($from_date));
	        $to_date = str_replace('/', '-', $to_date);
	        $to_date=date('Y-m-d', strtotime($to_date));

			$operator_id = $this->input->post('opertorList');
			if($operator_id!='')
			{
				$operator_search = 't1.added_by ="'.$operator_id.'" '; 
			}
			else
			{
				$operator_search ='t1.added_by="'.$admin_id.'" ';
			}
			if ($from_date!='' && $to_date=='1970-01-01') 
			{
				$date_search = ' t1.added_date >="'.$from_date.'" '; 
		  	}else if ($to_date!='' && $from_date=='1970-01-01') {
				$date_search = '  t1.added_date <="'.$to_date.'" '; 
		  	}else if ($from_date!='' && $to_date!='') {
			$date_search = 't1.added_date BETWEEN "'.$from_date.'" AND "'.$to_date.'" '; 
		 	 } else
		 	 {
		 	 	$date_search='';
		 	 }
		 	 if($operator_search!='')
		 	 {
				$condition=$operator_search."AND ".$date_search;
			 }
		  	else
		  	{
		  		$condition=$date_search;
		  	}

			
			$data['result']=$this->Mainmodel->getclients_filter($condition);
			
			
		}
		else
		{
			$data['result']=$this->Mainmodel->getclients($admin_id);
		
			if($admin_type=='super')
			{
				$data['result']=$this->Mainmodel->getclients();
			}
			else if($admin_type=='sub')
			{
				$data['result']=$this->Mainmodel->getclients($admin_id);
			}
		}
		$data['main_content']='client-list';
		$this->load->view('includes/template',$data);
	}	
	public function details()
	{
		$data['page_title']='Client Details';
		$id = $this->uri->segment(3);
		if($id!="")
		{
			$data['clientData'] = $this->Mainmodel->select_single_row('client',array('client_id'=>$id));
			$data['appointments'] = $this->Mainmodel->select_results_where('appointment',array('client_id'=>$id));
		}
		$data['main_content']='client-details';
		$this->load->view('includes/template',$data);
	}
	public function publish()
	{
		$id = $this->uri->segment(3);
		$page_name = $this->uri->segment(4);
		$table = $this->uri->segment(5);
		$field_name = $this->uri->segment(6);
		$status = $this->uri->segment(7);
		$status_field = $this->uri->segment(8);
		$publish = $this->Mainmodel->comm_publish($id,$table,$field_name,$status,$status_field);
		if($publish)
		{
			$this->session->set_flashdata('success',$status.' Successfully');
			redirect($page_name);
		}
	}
	public function add_quatation()
	{
		
		if(isset($_POST['upload_quatation']))
        {
        	
        	$id= $this->input->post('client_id');
        	if($_FILES["quotation_file"]['name'] !="") 
			{
				$quatation_file = $this->Mainmodel->doc_upload(6,'quotation_file','quatation_files');

			}
			$query=$this->db->query("UPDATE lm_client SET quatation='".$quatation_file."' WHERE client_id=$id ");
			$this->session->set_flashdata('success','Quatation Added Successfully');
			redirect('client-list.php');
		}
		$id= $this->input->post('client_id');
		$details=$this->Mainmodel->select_single_row('client',array('client_id'=>$id,'client_status'=>'active'));

		$content='<br>
		<h4 class="modal-title" id="myModalLabel" style="padding: 5px 20px;">Add New Quatation Here</h4>
		<div class="modal-body">
              <form id="" class="form-horizontal" role="form" method="POST" enctype="multipart/form-data" action="'.base_url().'client/add_quatation'.'">
              <div class="form-group">
                  <label class="col-sm-3 control-label">Quatation File</label>
                  <div class="col-sm-9">
                  	<input type="hidden" name="client_id" value="'.$id.'">
                    <input type="file" class="form-control" name="quotation_file" required>
				  <span style="color:red" id="error"></span>
                  </div>
                </div>
               <br>
                 <div class="col-xs-12 bottom">
            <div class="col-xs-12 col-sm-6 emphasis">
              <p class="ratings">
                <input type="submit" style="float:right;" name="upload_quatation" class="btn btn-success" value="Upload" id="upload_quatation"  >
              </p>
            </div>
            <div class="col-xs-12 col-sm-6 emphasis">
              	<button type="button" id="close_modal" class="btn btn-default" data-dismiss="modal" >Close</button>
      	  	</div>
          </div>
        ';

        echo $content;   
     }

     public function send_message()
     {
     	if(isset($_POST['send_msg']))
        {
		  $mobile= $this->input->post('client_mobile');
		  if($mobile=="")
		  {
			echo "mobile number is not available..!";
		  }
		  $message=$this->input->post('client_msg');

		  $username = 'Richsys';
		  $password = 'welcome@123';
		  $from = 'ENQURY';
		   $url="http://www.smsjust.com/sms/user/urlsms.php";
		   $c = curl_init(); 
		   curl_setopt($c, CURLOPT_URL, $url);
		   curl_setopt($c, CURLOPT_POST, true);
		   curl_setopt($c, CURLOPT_POSTFIELDS, 'username='.$username.'&pass='.$password.'&type=0&dlr=0&senderid='.$from.'&message='.$message.'&dest_mobileno='.$mobile.'&response=Y');
			curl_setopt($c, CURLOPT_RETURNTRANSFER, true); 
		    $curl_scraped_page = curl_exec($c); 
			curl_close($c);
			$this->session->set_flashdata('success','Your Message Has Been Send Successfully');
			redirect('client-list.php');
		}

		$mobile= $this->input->post('client_mobile');
		if($mobile=="")
		{
      $content='<br>
		<h4 class="modal-title" id="myModalLabel" style="padding: 5px 20px;">Send Message</h4>
		<div class="modal-body">
              <form id="" class="form-horizontal" role="form" method="POST" enctype="multipart/form-data" action="'.base_url().'client/send_message'.'">
              <div class="form-group">
                   <label class="col-sm-8 control-label">Mobile Number Is Not Available...!</label>
                  <div class="col-sm-9">
              
                  </div>
                </div>
               <br>
                 <div class="col-xs-12 bottom">
            <div class="col-xs-12 col-sm-6 emphasis">
              <p class="ratings">
          
              </p>
            </div>
            <div class="col-xs-12 col-sm-6 emphasis">
              	<button type="button" id="close_modal" class="btn btn-default" data-dismiss="modal" >Close</button>
      	  	</div>
          </div>
        ';

		}else{

		$content='<br>
		<h4 class="modal-title" id="myModalLabel" style="padding: 5px 20px;">Send Message</h4>
		<div class="modal-body">
              <form id="" class="form-horizontal" role="form" method="POST" enctype="multipart/form-data" action="'.base_url().'client/send_message'.'">
              <div class="form-group">
                  <label class="col-sm-3 control-label">Type Your Message Here</label>
                  <div class="col-sm-9">
                  <input type="hidden" name="client_mobile" value="'.$mobile.'">
                  	<textarea name="client_msg"></textarea>
                  </div>
                </div>
               <br>
                 <div class="col-xs-12 bottom">
            <div class="col-xs-12 col-sm-6 emphasis">
              <p class="ratings">
                <input type="submit" style="float:right;" name="send_msg" class="btn btn-success" value="Send" id=""  >
              </p>
            </div>
            <div class="col-xs-12 col-sm-6 emphasis">
              	<button type="button" id="close_modal" class="btn btn-default" data-dismiss="modal" >Close</button>
      	  	</div>
          </div>
        ';
        }

        echo $content;   
     }
  }



	
 ?>