<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 class Group extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->load->library('session');
		$this->load->helper("security");
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		if(!$this->session->userdata('admin_LoggedIn') || $this->session->userdata('admin_LoggedIn')=='')
		{
			redirect('login');
		}
    }
 
	//Check admin session
	
	
	public function index()
	{
		$data['page_title'] = "Lead Management | Add Group";
		$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
		$data['adminData']=$this->Mainmodel->select_single_row('admin',array('admin_id'=>$admin_id,'status'=>'active'));
		if($this->input->post('submit'))
		{
			$name=$this->input->post('group_name');
			$this->form_validation->set_rules('group_name','Name','required|callback_check_group');			

			if ($this->form_validation->run() == TRUE) 
			{
				$date=date('Y-m-d H:i:s');
				$params=array(
				"group_name"=>$this->input->post("group_name"),
				"added_date"=>$date	
				);
				$insert=$this->db->insert('group',$params);				
					if($insert)
					{
						$this->session->set_flashdata('success','Group Added Successfully');
						redirect(base_url().'group-list.php');
					}
			}
		}
		$data['main_content'] = "add-group";
		$this->load->view('includes/template',$data);
	}
	public function check_group(){

    $this->form_validation->set_message('group_name', 'Group allready exist.');
	$group_name=$this->input->post('group_name');
	$test=$this->db->get_where('group',array('group_status'=>'Publish','group_name'=>$group_name))->row();
    if ($test){
            return false;
        }else{
            return true;
        }
}
	public function group_list()
	{
	$data['page_title']='Group List';
	$data['result']=$this->db->get_where('group',array('group_status'=>'Publish'))->result();
	$data['main_content']='group-list';
	$this->load->view('includes/template',$data);
	}	
 }
 ?>