<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 class Client extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->load->library('session');
		$this->load->helper("security");
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		if(!$this->session->userdata('adminLoggedIn') || $this->session->userdata('adminLoggedIn')=='')
		{
			redirect('login');
		}
    }
 
	//Check admin session
	
	
	public function index()
	{
		$data['page_title'] = "Lead Management | Add Client";
		$admin_id = $this->session->userdata['adminLoggedIn']['adminId'];
		$data['adminData']=$this->Mainmodel->select_single_row('admin',array('admin_id'=>$admin_id,'status'=>'active'));
		$data['group']=$this->db->get_where('group',array('group_status'=>'Publish'))->result();
			if($_POST)
			{
				$this->load->library('email');				
				$this->form_validation->set_rules('name', 'Name', 'trim|required');	
				$this->form_validation->set_rules('group', 'Group', 'trim|required');	
				$this->form_validation->set_rules('mobile', 'Mobile', 'trim|regex_match[/^[0-9]{10}$/]|required');
				$this->form_validation->set_rules('email', 'Email', 'trim|is_unique[client.client_email]|required');
				$this->form_validation->set_rules('address', 'Address', 'trim|required');		
			 if($this->form_validation->run() == true){
				$date=date('Y-m-d H:i:s');
				$params=array(	
				'group_id'=>$this->input->post('group'),
					'client_name'=>$this->input->post('name'),					
					'client_address'=>$this->input->post('address'),
					'client_mobile'=>$this->input->post('mobile'),
					'client_email'=>$this->input->post('email'),
					'added_date'=>$date						
					);
				
					$insert=$this->db->insert('client',$params);
					if($insert)
					{
						$this->session->set_flashdata('success','Client registered!');
						redirect(base_url().'client-list.php');
					}
			 }					
			}
		$data['main_content'] = "add-client";
		$this->load->view('includes/template',$data);
	}
	public function client_list()
	{
	$data['page_title']='Client List';
	//$data['result']=$this->db->get_where('client',array('client_status'=>'Active'))->result();
	$data['result']=$this->Mainmodel->getclients();
	$data['main_content']='client-list';
	$this->load->view('includes/template',$data);
	}	
	public function publish()
	{
		$id=$this->uri->segment(3);
		$page_name=$this->uri->segment(4);
		$table=$this->uri->segment(5);
		$field_name=$this->uri->segment(6);
		$status=$this->uri->segment(7);
		$status_field=$this->uri->segment(8);
		$publish=$this->Mainmodel->comm_publish($id,$table,$field_name,$status,$status_field);
		if($publish)
		{
			$this->session->set_flashdata('success',$status.' Successfully');
			redirect($page_name);
		}
	}
	
	
 }
 ?>