<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/* Author: Jorge Torres
 * Description: Home controller class
 * This is only viewable to those members that are logged in
 */
 class Login extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->helper('security');
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		if($this->session->userdata('adminLoggedIn') || $this->session->userdata('adminLoggedIn')!='')
		{
			redirect('home');
		}
    }
 
	//Check admin session
	public function index()
	{
		if($this->input->post('submit'))
		{
			$this->form_validation->set_rules('username','Username','trim|xss_clean|required');
			$this->form_validation->set_rules('password','password','trim|xss_clean|required');
			if($this->form_validation->run()=="TRUE")
			{
				$username = $this->input->post('username');
				$password= $this->input->post('password');
				$result = $this->Mainmodel->login($username,$password);
				if($result!='')
				{
					$adminData = array(
						'adminId' => $result->admin_id,
						'adminName' => $result->admin_name,
						'admin_username' => $result->username,
						'is_logged_in' => true
					);
					$this->session->set_userdata('adminLoggedIn',$adminData);
					$this->session->set_flashdata('success','Login Successfully');
					redirect('home');
				}
				else
				{ // incorrect username or password
					$this->session->set_flashdata('fail','Invalid Credentials');
					redirect('login');
				}
			}
		}
		$data['page_title']="Login - Lead Management";
		$this->load->view('login',$data);
    }

	
	function check_database($login_pass)
	{
		$login_id = $this->input->post('login_id'); 
		$login_pass = md5($this->input->post('login_pass'));  
		$this->db->select('email_id,password,rand_id')->from('distributor')->where('email_id',$this->input->post('login_id')); 
		$user_details = $this->db->get(); 
		$result_user  = $user_details->row();	
		$result = $this->user->user_login($login_id, $login_pass);  
		if($result)
		{
		  $sess_array = array();
		  foreach($result as $row)
		  {
			  $sess_array = array(
			  'rand_id' => $row->rand_id,
			  'login_id' =>$row->login_id,
			  'login_pass' =>$row->login_pass,
			  'email' =>$row->email_id,
			);
			
			$this->session->set_userdata('distributor_logged_in',$sess_array);
			$this->session->set_userdata('login_id',$row->login_id);
			redirect(base_url().'home/dashboard','refresh');
		  }
		}
	}
 }
 ?>