<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/* Author: Jorge Torres
 * Description: Home controller class
 * This is only viewable to those members that are logged in
 */
 class Home extends CI_Controller{
    function __construct(){
        parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->load->helper('all_function_helper');
		$this->load->library('session');
		$this->load->helper("security");
		$this->load->model('Mainmodel');
		date_default_timezone_set('Asia/Calcutta'); 
		$this->load->library('form_validation');
		
		
		if(!$this->session->userdata('admin_LoggedIn') || $this->session->userdata('admin_LoggedIn')=='')
		{
			redirect('login');
		}
    }
 
	//Check admin session
	public function index()
	{
		$data['page_title']='Lead Management';		
		$data['main_content'] = "index";
		$data['total_group'] = $this->db->where('group_status', 'Publish')->get('group')->num_rows();
		$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
		$admin_type = $this->session->userdata['admin_LoggedIn']['admin_type'];
		if($admin_type!='super')
		{
			$id=$admin_id;
			$arrayCond = array('client_status'=>'Active','added_by'=>$id);
			$condition1=array('added_by'=>$id);
			$condition="DATE_FORMAT(`app_date`,'%Y-%c-%d') = CURDATE() AND added_by=".$id;
		}
		else
		{
			$id=$admin_id;
			$arrayCond = array('client_status'=>'Active');
			$condition1=array('added_by'=>$id);
			$condition = "DATE_FORMAT(`app_date`,'%Y-%c-%d') = CURDATE()";
		}
		$data['total_client'] = $this->db->get_where('client',$arrayCond)->num_rows();
		$data['total_app'] = $this->db->get_where('appointment',$condition1)->num_rows();
		$date=date('Y-m-d');
		$data['total_app_complete'] = $this->db->where($condition)->get('appointment')->num_rows();
		//echo $this->db->last_query();die;
		
		$this->load->view('includes/template',$data);
    }
	
	public function site_setting()
	{
		$data['page_title'] = "Site Setting";
		$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
		$data['adminData']=$this->Mainmodel->select_single_row('admin',array('admin_id'=>$admin_id,'status'=>'active'));
		if($this->input->post('submit'))
		{
			
			$name=$this->input->post('firstname');
			$this->form_validation->set_rules('admin_name','Name','required');
			$this->form_validation->set_rules('admin_contact_number','Mobile no','required');
			$this->form_validation->set_rules('admin_email_id','Email id','required');
			$this->form_validation->set_rules('site_name','site name','required');
			$this->form_validation->set_rules('site_url','Site Url','required');
			$this->form_validation->set_rules('site_description','Site Description','required');

			if ($this->form_validation->run() == TRUE) 
			{
				$data=array(
				"admin_name"=>$this->input->post("admin_name"),
				"admin_contact_number"=>$this->input->post("admin_contact_number"),								
				"admin_email_id"=>$this->input->post("admin_email_id"),
				"site_name"=>$this->input->post("site_name"),
				"site_url"=>$this->input->post("site_url"),
				"site_description"=>$this->input->post("site_description")
				);
			$this->db->where('admin_id','1');
			$this->db->update('admin',$data);
				if(isset($_FILES['logo']))
				{
					$config = array(
						'upload_path' => "common/images/",
						'allowed_types' => "gif|jpg|png|jpeg|pdf",
						'overwrite' => TRUE,
						'max_size' => "2048000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
						'max_height' => "768",
						'max_width' => "1024"
						);
					$this->load->library('upload', $config);
					if($this->upload->do_upload('logo'))
					{
						$data = array('upload_data' => $this->upload->data());
					}
					else
					{
						$error = array('error' => $this->upload->display_errors());
					}
				}
				redirect('home/site_setting');
			}
		}
		$data['main_content'] = "site-setting";
		$this->load->view('includes/template',$data);
	}
	
public function add_appointment()
{
	$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
	$admin_type = $this->session->userdata['admin_LoggedIn']['admin_type'];
	if($admin_type!='super')
	{
		$data['admin_id'] = $admin_id;
		$arrayCond = array('client_status'=>'Active','added_by'=>$admin_id);
	}
	else
	{
		$data['admin_id'] = "";
		$arrayCond = array('client_status'=>'Active');
	}
	$data['main_content'] = "add-appointment";
	$data['client_list']=$this->db->get_where('client',$arrayCond)->result();
	if($_POST)
	{
		$client_name=$this->input->post('title');
		$pieces = explode('-', $client_name);
		$client_mobile = array_pop($pieces);			
		$time=$this->input->post('date-time');
		$start_date=date('Y-m-d H:i',strtotime($this->input->post('start_date').$time));				
		$details=$this->db->get_where('client',array('client_mobile'=>$client_mobile))->row();
		$params=array(
		'client_id'=>$details->client_id,
		'app_time'=>$time,
		'app_desc'=>$this->input->post('descr'),
		'app_status'=>'Incomplete',
		'added_by'=>$admin_id,
		'app_date'=>$start_date,
		);		
		$this->db->insert('appointment',$params);
		redirect(base_url().'appointment-list.php');
	}
	$this->load->view('includes/template',$data);
}
public function appointment_list()
{
	$data['main_content'] = "appointment-list";
	$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
	$data['result']=$this->Mainmodel->getAppointmentList($admin_id);
	$this->load->view('includes/template',$data);
}

public function todays_appointment_list()
{
	$data['main_content'] = "appointment-list";
	$admin_id = $this->session->userdata['admin_LoggedIn']['adminId'];
	$data['result']=$this->Mainmodel->getTodaysAppointmentList($admin_id);
	$this->load->view('includes/template',$data);
}

public function change_password()
{
	$data['main_content'] = "change-password";	

	if($this->input->post('submit'))
		{
			
			$this->form_validation->set_rules('current_password','current_password','required');
			$this->form_validation->set_rules('new_password','new_password','required');
			$this->form_validation->set_rules('confirm_password','confirm_password','required');
			if ($this->form_validation->run() == TRUE) 
			{
				$new_password=$this->input->post('new_password');
				$confirm_password=$this->input->post('confirm_password');
				$current_password=base64_encode($this->input->post('current_password'));
				
				$check=$this->db->get_where('admin',array('password'=>$current_password,'admin_id'=>'1'))->row();
				
				if($new_password==$confirm_password && $check)
				{
					$data=array(
					"password"=>base64_encode($this->input->post("new_password"))				
					);
					$this->db->where('admin_id','1');
					$this->db->update('admin',$data);
					$this->session->set_flashdata('success','password updated!');
					redirect('home/change_password');
				}	
				else
				{
					$this->session->set_flashdata('error','Sorry password not match');
					redirect('home/change_password');
				}				
			
			}
		}
		
		$this->load->view('includes/template',$data);
}
public function getClient()
{
	$client_name=$this->input->post("client_name");
			$start_date=$this->input->post("start_date");
			$date_time=$this->input->post("date_time");
			$patient_status='Incomplete';
			$pieces = explode('-', $client_name);
			$client_mobile = array_pop($pieces);
	
	$row=$this->db->get_where('client',array('client_mobile'=>$client_mobile))->row();
	if($row){
				echo ' <br><br>
				<p style="color: Red;font-size: 18px;text-align: center;">Client Information</p>
				<table class="table table-striped" align="center"> 
				</tr>
				<tr> <td>Name</td><td>'.$row->client_name.'</td> </tr>
				<tr> <td>Mobile No</td><td>'.$row->client_mobile.'</td> </tr>
				<tr> <td>Client Email</td><td>'.$row->client_email.'</td> </tr>								
				<tr> <td>Client Address</td><td>'.$row->client_address.' </td> </tr>
				</table>
				 <input type="submit" style="float:right;" name="assign_schedule" class="btn btn-success" value="Schedule Now" id="assign_schedule"  >
				';
				}
				else{
				echo '<br><p style="color: Red;font-size: 18px;text-align: center;">No Record Found</p>';

				}
}

	public function change_appoint_status()
	{
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$this->db->where('app_id',$id);
		$this->db->update('appointment',array('app_status'=>$status));
		if($this->db->affected_rows()>0)
		{
			echo "1";
		}
		else 
		{
			echo "0";
		} 
	}
	public function logout()
	{
		$this->session->unset_userdata('admin_LoggedIn');
		session_destroy();
		redirect(base_url().'login');
	}
	
 }
 ?>