@extends('layouts.settings.default')
@section('settings_title',trans('lang.notification_type_table'))
@section('settings_content')
  @include('flash::message')
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
        <li class="nav-item">
          <a class="nav-link" href="{!! url('settings/app/notifications')  !!}"><i class="fa fa-bell mr-2"></i>{{trans('lang.app_setting_notifications')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="{!! url()->current() !!}"><i class="fa fa-list mr-2"></i>{{trans('lang.notification_type_table')}}</a>
        </li>
        @can('notificationTypes.create')
        <li class="nav-item">
          <a class="nav-link" href="{!! route('notificationTypes.create') !!}"><i class="fa fa-plus mr-2"></i>{{trans('lang.notification_type_create')}}</a>
        </li>
        @endcan
        @include('layouts.right_toolbar', compact('dataTable'))
      </ul>
    </div>
    <div class="card-body">
      @include('notification_types.table')
      <div class="clearfix"></div>
    </div>
  </div>
@endsection

